<?php
include("bl_Common.php");
include_once("bl_Functions.php");

$link = Connection::dbConnect();

if (isset($_POST['type'])) {
    $type = Utils::sanitaze_var($_POST['type'], $link);
}
if (isset($_POST['reported_id'])) {
    $reported_id = Utils::sanitaze_var($_POST['reported_id'], $link);
}
if (isset($_POST['reported_nick'])) {
    $reported_nick = Utils::sanitaze_var($_POST['reported_nick'], $link);
}
if (isset($_POST['submitter_id'])) {
    $submitter_id = Utils::sanitaze_var($_POST['submitter_id'], $link);
}
if (isset($_POST['report_type'])) {
    $report_type = Utils::sanitaze_var($_POST['report_type'], $link);
}
if (isset($_POST['hash'])) {
    $hash = Utils::sanitaze_var($_POST['hash'], $link);
}

const USERS_REPORTS_TABLE = 'bl_game_users_reports';
const REPORT_METADATA_TABLE = 'bl_game_reports_meta';

$functions = new Functions($link);

if ($hash == Utils::get_secret_hash('')) {
    
    switch ($type) {
        
        case 1: // subtmit a report with the information from the request parameters
            
            $sql = "INSERT INTO " . REPORT_METADATA_TABLE . " (user_reported_id, submitter_user_id, report_type) VALUES ('$reported_id', '$submitter_id', '$report_type')";
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            mysqli_free_result($result);
            
            $sql = "SELECT id FROM " . USERS_REPORTS_TABLE . " WHERE user_id='{$reported_id}'";
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            if (mysqli_num_rows($result) <= 0) {
                
                mysqli_free_result($result);
                $sql = "INSERT INTO " . USERS_REPORTS_TABLE . " (user_id, user_nick, reports) VALUES ('$reported_id', '$reported_nick', '$report_type')";
                $result = mysqli_query($link, $sql) or die(mysqli_error($link) . $sql);
                
                if ($result) {
                    http_response_code(202);
                } else {
                    http_response_code(204);
                }
            } else {
                mysqli_free_result($result);
                $sql = "UPDATE " . USERS_REPORTS_TABLE . " SET reports=reports+1, user_nick='$reported_nick' WHERE user_id='$reported_id'";
                $result = mysqli_query($link, $sql) or die(mysqli_error($link));
                
                if ($result) {
                    http_response_code(202);
                } else {
                    http_response_code(204);
                }
            }
            
            break;
        case 2: // try to submit report to an user by their nick name.
            
            $sql = "SELECT * FROM " . PLAYERS_DB . " WHERE nick='$reported_nick'";
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            if (mysqli_num_rows($result) <= 0) {
                // if couldn't found an user with this nick name
                // it could mean that the reported player is playing as a guest.
                http_response_code(206);
            }
            
            $rows        = mysqli_fetch_assoc($result);
            $reported_id = $rows['id'];
            
            $sql = "INSERT INTO " . REPORT_METADATA_TABLE . " (user_reported_id, submitter_user_id, report_type) VALUES ('$reported_id', '$submitter_id', '$report_type')";
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            mysqli_free_result($result);
            
            $sql = "SELECT id FROM " . USERS_REPORTS_TABLE . " WHERE user_id='{$reported_id}'";
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            if (mysqli_num_rows($result) <= 0) {
                
                mysqli_free_result($result);
                $sql = "INSERT INTO " . USERS_REPORTS_TABLE . " (user_id, user_nick, reports) VALUES ('$reported_id', '$reported_nick', '1')";
                $result = mysqli_query($link, $sql) or die(mysqli_error($link) . $sql);
                
                if ($result) {
                    http_response_code(202);
                } else {
                    http_response_code(204);
                }
            } else {
                mysqli_free_result($result);
                $sql = "UPDATE " . USERS_REPORTS_TABLE . " SET reports=reports+1, user_nick='$reported_nick' WHERE user_id='$reported_id'";
                $result = mysqli_query($link, $sql) or die(mysqli_error($link));
                
                if ($result) {
                    http_response_code(202);
                } else {
                    http_response_code(204);
                }
            }
            
            break;
        case 3:
            
            // $report_type = page, $submitter_id = results per page
            $sql = "SELECT * FROM " . USERS_REPORTS_TABLE . " ORDER BY reports LIMIT $report_type,$submitter_id";
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            if ($result) {
                
                if (mysqli_num_rows($result) <= 0) {
                    http_response_code(204);
                    exit();
                }
                
                $rows = array();
                while ($r = mysqli_fetch_assoc($result)) {
                    $rows[] = $r;
                }
                echo json_encode($rows);
                http_response_code(200);
                
            } else {
                http_response_code(500);
            }
            break;
        case 4: // get all reports of a specific player
            
            $sql = "SELECT * FROM " . REPORT_METADATA_TABLE . " WHERE user_reported_id='$reported_id'";
            
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            if ($result) {
                
                if (mysqli_num_rows($result) <= 0) {
                    echo "id" . $reported_id;
                    http_response_code(204);
                    exit();
                }
                
                $rows = array();
                while ($r = mysqli_fetch_assoc($result)) {
                    $rows[] = $r;
                }
                echo json_encode($rows);
                http_response_code(200);
                
            } else {
                http_response_code(500);
            }
            
            break;
        case 5: // delete all player reports
            
            $sql = "DELETE FROM " . REPORT_METADATA_TABLE . " WHERE user_reported_id='$reported_id';";
            $sql .= "DELETE FROM " . USERS_REPORTS_TABLE . " WHERE user_id='$reported_id'";
            
            if ($functions->multiple_query($sql)) {
                http_response_code(200);
            }
            
            break;
        case 6: // get player account data from user id
            
            $sql = "SELECT * FROM " . PLAYERS_DB . " WHERE id='$submitter_id'";
            $result = mysqli_query($link, $sql) or die(mysqli_error($link));
            
            if (mysqli_num_rows($result) <= 0) {
                http_response_code(204);
                exit();
            }
            
            $rows = array();
            while ($r = mysqli_fetch_assoc($result)) {
                $rows[] = $r;
            }
            
            unset($rows[0]['password']);
            
            echo json_encode($rows);
            http_response_code(200);
            
            break;
        default:
            http_response_code(404);
            break;
    }
    
} else {
    http_response_code(401);
}

mysqli_close($link);
?>